/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.rendering;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.blend.BlendMode;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.interactive.annotation.AnnotationFilter;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PageDrawer;
import org.apache.pdfbox.rendering.PageDrawerParameters;

public class PDFRenderer {
    private static final Log LOG = LogFactory.getLog(PDFRenderer.class);
    protected final PDDocument document;
    private AnnotationFilter annotationFilter = new AnnotationFilter(){

        @Override
        public boolean accept(PDAnnotation annotation) {
            return true;
        }
    };
    private boolean subsamplingAllowed = false;
    private BufferedImage pageImage;
    private static boolean kcmsLogged = false;

    public PDFRenderer(PDDocument document) {
        this.document = document;
        if (!kcmsLogged) {
            PDFRenderer.suggestKCMS();
            kcmsLogged = true;
        }
    }

    public AnnotationFilter getAnnotationsFilter() {
        return this.annotationFilter;
    }

    public void setAnnotationsFilter(AnnotationFilter annotationsFilter) {
        this.annotationFilter = annotationsFilter;
    }

    public boolean isSubsamplingAllowed() {
        return this.subsamplingAllowed;
    }

    public void setSubsamplingAllowed(boolean subsamplingAllowed) {
        this.subsamplingAllowed = subsamplingAllowed;
    }

    public BufferedImage renderImage(int pageIndex) throws IOException {
        return this.renderImage(pageIndex, 1.0f);
    }

    public BufferedImage renderImage(int pageIndex, float scale) throws IOException {
        return this.renderImage(pageIndex, scale, ImageType.RGB);
    }

    public BufferedImage renderImageWithDPI(int pageIndex, float dpi) throws IOException {
        return this.renderImage(pageIndex, dpi / 72.0f, ImageType.RGB);
    }

    public BufferedImage renderImageWithDPI(int pageIndex, float dpi, ImageType imageType) throws IOException {
        return this.renderImage(pageIndex, dpi / 72.0f, imageType);
    }

    public BufferedImage renderImage(int pageIndex, float scale, ImageType imageType) throws IOException {
        PDPage page = this.document.getPage(pageIndex);
        PDRectangle cropbBox = page.getCropBox();
        float widthPt = cropbBox.getWidth();
        float heightPt = cropbBox.getHeight();
        int widthPx = (int)Math.max(Math.floor(widthPt * scale), 1.0);
        int heightPx = (int)Math.max(Math.floor(heightPt * scale), 1.0);
        int rotationAngle = page.getRotation();
        int bimType = imageType.toBufferedImageType();
        if (imageType != ImageType.ARGB && this.hasBlendMode(page)) {
            bimType = 2;
        }
        BufferedImage image = rotationAngle == 90 || rotationAngle == 270 ? new BufferedImage(heightPx, widthPx, bimType) : new BufferedImage(widthPx, heightPx, bimType);
        this.pageImage = image;
        Graphics2D g = image.createGraphics();
        if (image.getType() == 2) {
            g.setBackground(new Color(0, 0, 0, 0));
        } else {
            g.setBackground(Color.WHITE);
        }
        g.clearRect(0, 0, image.getWidth(), image.getHeight());
        this.transform(g, page, scale, scale);
        PageDrawerParameters parameters = new PageDrawerParameters(this, page, this.subsamplingAllowed);
        PageDrawer drawer = this.createPageDrawer(parameters);
        drawer.drawPage(g, page.getCropBox());
        g.dispose();
        if (image.getType() != imageType.toBufferedImageType()) {
            BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), imageType.toBufferedImageType());
            Graphics2D dstGraphics = newImage.createGraphics();
            dstGraphics.setBackground(Color.WHITE);
            dstGraphics.clearRect(0, 0, image.getWidth(), image.getHeight());
            dstGraphics.drawImage((Image)image, 0, 0, null);
            dstGraphics.dispose();
            image = newImage;
        }
        return image;
    }

    public void renderPageToGraphics(int pageIndex, Graphics2D graphics) throws IOException {
        this.renderPageToGraphics(pageIndex, graphics, 1.0f);
    }

    public void renderPageToGraphics(int pageIndex, Graphics2D graphics, float scale) throws IOException {
        this.renderPageToGraphics(pageIndex, graphics, scale, scale);
    }

    public void renderPageToGraphics(int pageIndex, Graphics2D graphics, float scaleX, float scaleY) throws IOException {
        PDPage page = this.document.getPage(pageIndex);
        this.transform(graphics, page, scaleX, scaleY);
        PDRectangle cropBox = page.getCropBox();
        graphics.clearRect(0, 0, (int)cropBox.getWidth(), (int)cropBox.getHeight());
        PageDrawerParameters parameters = new PageDrawerParameters(this, page, this.subsamplingAllowed);
        PageDrawer drawer = this.createPageDrawer(parameters);
        drawer.drawPage(graphics, cropBox);
    }

    private void transform(Graphics2D graphics, PDPage page, float scaleX, float scaleY) {
        graphics.scale(scaleX, scaleY);
        int rotationAngle = page.getRotation();
        PDRectangle cropBox = page.getCropBox();
        if (rotationAngle != 0) {
            float translateX = 0.0f;
            float translateY = 0.0f;
            switch (rotationAngle) {
                case 90: {
                    translateX = cropBox.getHeight();
                    break;
                }
                case 270: {
                    translateY = cropBox.getWidth();
                    break;
                }
                case 180: {
                    translateX = cropBox.getWidth();
                    translateY = cropBox.getHeight();
                    break;
                }
            }
            graphics.translate(translateX, translateY);
            graphics.rotate((float)Math.toRadians(rotationAngle));
        }
    }

    protected PageDrawer createPageDrawer(PageDrawerParameters parameters) throws IOException {
        PageDrawer pageDrawer = new PageDrawer(parameters);
        pageDrawer.setAnnotationFilter(this.annotationFilter);
        return pageDrawer;
    }

    private boolean hasBlendMode(PDPage page) {
        PDResources resources = page.getResources();
        if (resources == null) {
            return false;
        }
        for (COSName name : resources.getExtGStateNames()) {
            BlendMode blendMode;
            PDExtendedGraphicsState extGState = resources.getExtGState(name);
            if (extGState == null || (blendMode = extGState.getBlendMode()) == BlendMode.NORMAL) continue;
            return true;
        }
        return false;
    }

    BufferedImage getPageImage() {
        return this.pageImage;
    }

    private static void suggestKCMS() {
        String cmmProperty = System.getProperty("sun.java2d.cmm");
        if (PDFRenderer.isMinJdk8() && !"sun.java2d.cmm.kcms.KcmsServiceProvider".equals(cmmProperty)) {
            try {
                Class.forName("sun.java2d.cmm.kcms.KcmsServiceProvider");
                LOG.info("To get higher rendering speed on java 8 or 9,");
                LOG.info("  use the option -Dsun.java2d.cmm=sun.java2d.cmm.kcms.KcmsServiceProvider");
                LOG.info("  or call System.setProperty(\"sun.java2d.cmm\", \"sun.java2d.cmm.kcms.KcmsServiceProvider\")");
            }
            catch (ClassNotFoundException e) {
                LOG.debug("KCMS doesn't exist anymore. SO SAD!");
            }
        }
    }

    private static boolean isMinJdk8() {
        String version = System.getProperty("java.specification.version");
        StringTokenizer st = new StringTokenizer(version, ".");
        try {
            int major = Integer.parseInt(st.nextToken());
            int minor = 0;
            if (st.hasMoreTokens()) {
                minor = Integer.parseInt(st.nextToken());
            }
            return major > 1 || major == 1 && minor >= 8;
        }
        catch (NumberFormatException nfe) {
            return true;
        }
    }
}

