# Generated by default/object.tt
package Paws::IoTWireless::SidewalkDeviceMetadata;
  use Moose;
  has BatteryLevel => (is => 'ro', isa => 'Str');
  has DeviceState => (is => 'ro', isa => 'Str');
  has Event => (is => 'ro', isa => 'Str');
  has Rssi => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTWireless::SidewalkDeviceMetadata

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTWireless::SidewalkDeviceMetadata object:

  $service_obj->Method(Att1 => { BatteryLevel => $value, ..., Rssi => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTWireless::SidewalkDeviceMetadata object:

  $result = $service_obj->Method(...);
  $result->Att1->BatteryLevel

=head1 DESCRIPTION

MetaData for Sidewalk device.

=head1 ATTRIBUTES


=head2 BatteryLevel => Str

Sidewalk device battery level.


=head2 DeviceState => Str

Device state defines the device status of sidewalk device.


=head2 Event => Str

Sidewalk device status notification.


=head2 Rssi => Int

The RSSI value.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTWireless>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

