use strict;
use warnings;
use Test::More tests => 68;
use Digest::EdonR qw(edonr_256 edonr_256_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::EdonR->new(256)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            edonr_256_hex($data), $digest,
            "edonr_256_hex: $len bits of $msg"
        );
        ok(
            edonr_256($data) eq pack('H*', $digest),
            "edonr_256: $len bits of $msg"
        );
    }

    my $md = Digest::EdonR->new(256)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

__DATA__
00|3B71FD43DADE942C07842B181F4D987E78D2AC7E3A7E8BB06FEC99A60B60EABA
00|1F7430D1FDCBD8E8483B1CD5083FCCF54CC57B1EBDEE3B9EAC8283261261FE8A
C0|F420810B59887AA81B75058C10FDCD6A6F53360F332E82C03CA0C06C9847034A
C0|43C81B94E26C657BA8130B892F64025816432C85B234C251D9C402C3DEF5C9D4
80|DEB4AAA0BC942B005F2C4FFA6EBF914C55195171FE02048187C5ADC0A6E806F4
48|F051BF71BD75CF6DE1DFC0392B3E3F5C3604359FD5305E1A059ECC99406C77FF
50|7DC3587875C16962E28A713C71E61584F15A98977537A244B54C51D04890FBAC
98|C1B64E96E2189901B305E604367699FD9D1B1AB53006E490934FCAB417B472D8
CC|38825E049F6DE1DA717680E8F78CAE86403FBBFDE9BC8E93CFD073DB9AD5DE7F
9800|9F89EF56EBFA1F671F4F507CF6228B1CA9F86823F93BB54DAF89C4C3FFDBDA0F
9D40|EB1B8A0E4AA877A1A8AEC53851216046652C3EE338624699BDC339C6957F1A1F
AA80|B2CE8F762486E1A6091C416DA5EDB3B68F338AB8E03368927795F45A6C25F57B
9830|642C24D497B6F2266AA1827601A0F2586EC200837E8CE0312EA7194393A23FB1
5030|8FCDD66A596DD60743AEEB58DC1D0D5C1BD96F7965921241892378FF884CADA6
4D24|14D369F2D1AC26E2EA7F84ACAC1A406C0749F9ABF06BC608EF2447CC54519B73
CBDE|B60CACC7D15E17DB59F73AF438C84F74B0AE744BD71FC69D041A70BAB389F42B
41FB|1A175113F8AA0BABB53C360E16E903BDD8DC012393AAA99CDBA54E16EF8E7D40
4FF400|86F08891E243B4439FDB6EED68A4A92514804C5002FEEC12188A896677CA80CF
FD0440|0A5E3A6F657B62ECBDC685CBDCADDDC2E1B51F7D95FF56A66ADB5F271BE4903A
424D00|18B6C56BD5269DBE9024093D49E22BCF1051B2774D3C363763FC608B81B9117F
3FDEE0|89A56949294600318AC31FAAEEE68970BF9638527030465D59D963060D5A0547
335768|C89C72EA2E85470B8436CC4A87F70B63FFA9294EE7404E3CC5476E622409D802
051E7C|7CB5D4F7EEB1742BE824BE6B7C45628B41FA7E918B9A99AC21D46EF61B0D4484
717F8C|F604D14363731DAB4A69DDAE4C79D8243DD140024CE487CB4E6E0F3DA93E8A80
1F877C|020B04D6D14891DF446FE845D463110BE71129ED00C064CF47C12AF4E00B8ED3
EB35CF80|748D64CAE222EE717D12AD2544CCE15D2442F05D23949BB345107F8C88BAF75E
B406C480|FBCE96D02FC835EDF685EC782EA8FD9195A8BAC4F726D8E04117FEB9BCCA96CB
CEE88040|46AA78B896C9128564890CDA38FB6419C32A03EA9B5680E1BCFAAB64B4F32D36
C584DB70|EC7A7B51DE95D7DA058899A0BA5E1E8FAD373D28C6FB99DB3BAA4645EA04536D
53587BC8|B4C91A979FABEEAC61A9F96DF64DD49AEC4DDB1B51AD79E68B52DA6E7928AD90
69A305B0|FBFFF9C31E8731B18FDF6E6897DE7570A3C2E32DE70C59B98A2DB5670EC55467
C9375ECE|F64DC588B994718BF214FF8900CBC9D2B697B747213D8BB141CCBED0DDBF79B1
C1ECFDFC|1D2F5112279D5648708567AAE8A51E104C3FCFFC4E7DAA39272A190FDF3E17BE
8D73E8A280|23E22DFB98DF1E26BC14A15065724B45267B7DF649A308E2D1C27A66FAB350ED
06F2522080|193C1AF1C4FBF2F297396AD049C4000476217D108309686F5F03F00890B8471D
3EF6C36F20|FCB5D4DD4DF9A01DF66FCCB4871B6C40888AE790A3199300ADA4C8E24302ACAC
0127A1D340|9183A389BD42D3EBF0BD455E57941315B5321202124924F86BB7D9887229ED05
6A6AB6C210|D8E46F1EE1749FAB2C899BC2DA2CB378E1D741EB21C35A759FA2380A4A5E665A
AF3175E160|11F1BBDF0EFC6B90CD8D9DFFDF67A34100FCFB83CEA7708BF46418E0179C903C
B66609ED86|BC52F731C1ECB9BE535C5802427319F1A9949DA32C4B5D81F6B8DC346CF855B1
21F134AC57|13AC2BCB7BDF73CC683370ECC8BA94B5739E6CDAC4699D15CB9270D8FC72EDBC
3DC2AADFFC80|61ECB7C83F7265D7EAF04508EBAB067B8E904821668376463D3A360C6C25975C
9202736D2240|E4CE8B1F8073F77DEBE3D3B2EB7474AB19DC95AD2552583EE317D15DA7124C3E
F219BD629820|C2F39237E1AE0D51422BA67B9235AB2DB932E7F004B25FAE13214534D78C506A
F3511EE2C4B0|D25DDD08EA133CAA64EF0543A2BBEF6B156ED887BB62541CA419707B9790A7D5
3ECAB6BF7720|FBD90B941936F77D294CB925E5917BD99037C0A436EB5F43B1CC6F7C7D3C3051
CD62F688F498|88769433273883320B5C01D2F5B4B4ABE0CAE300C94BAD60132F5F80F2967352
C2CBAA33A9F8|1E6137D1311E715987AD7E1F8CDDFD7A9A53647AC04E79DE0769E7D523A9C131
C6F50BB74E29|6F6A0515FB21B0F4EF4C3DA38EF814108F33DC4933DCD6A91C20D793520968BB
79F1B4CCC62A00|D2B282C5ED2CCDA2E6CB0FC2B5B0EDC7A5DD6FD0ED71B936123951F4A2AABF54
