/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock;

import com.sun.net.httpserver.HttpServer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.couchbase.mock.Bucket;
import org.couchbase.mock.http.Authenticator;
import org.couchbase.mock.http.PoolsHandler;
import org.couchbase.mock.util.Getopt;

public class CouchbaseMock {
    private final Map<String, Bucket> buckets;
    private final String poolName = "default";
    private int port = 8091;
    private HttpServer httpServer;
    private Authenticator authenticator;
    private ArrayList<Thread> nodeThreads;
    private final CountDownLatch startupLatch = new CountDownLatch(1);
    private HarakiriMonitor monitor;

    public void setupHarakiriMonitor(String host, boolean terminate) throws IOException {
        int idx = host.indexOf(58);
        String h = host.substring(0, idx);
        int p = Integer.parseInt(host.substring(idx + 1));
        this.monitor = new HarakiriMonitor(h, p, terminate, this);
        this.monitor.start();
    }

    public String getPoolName() {
        return "default";
    }

    public Map<String, Bucket> getBuckets() {
        return this.buckets;
    }

    private void failover(String bucketName, int idx) {
        Bucket bucket = this.buckets.get(bucketName);
        if (bucket != null) {
            bucket.failover(idx);
        }
    }

    private void respawn(String bucketName, int idx) {
        Bucket bucket = this.buckets.get(bucketName);
        if (bucket != null) {
            bucket.respawn(idx);
        }
    }

    public HarakiriMonitor getMonitor() {
        return this.monitor;
    }

    public CouchbaseMock(String hostname, int port, int numNodes, int bucketStartPort, int numVBuckets, String bucketSpec) throws IOException {
        this.buckets = new HashMap<String, Bucket>();
        try {
            if (bucketSpec == null) {
                Bucket bucket = Bucket.create(Bucket.BucketType.COUCHBASE, "default", hostname, port, numNodes, bucketStartPort, numVBuckets, this, "");
                this.buckets.put("default", bucket);
            } else {
                for (String spec : bucketSpec.split(",")) {
                    String[] parts = spec.split(":");
                    String name = parts[0];
                    String pass = "";
                    Bucket.BucketType type = Bucket.BucketType.COUCHBASE;
                    if (parts.length > 1) {
                        pass = parts[1];
                        if (parts.length > 2 && "memcache".equals(parts[2])) {
                            type = Bucket.BucketType.MEMCACHE;
                        }
                    }
                    Bucket bucket = Bucket.create(type, name, hostname, port, numNodes, bucketStartPort, numVBuckets, this, pass);
                    this.buckets.put(name, bucket);
                }
            }
            this.port = port;
            this.authenticator = new Authenticator("Administrator", "password", this.buckets);
        }
        catch (SecurityException ex) {
            Logger.getLogger(CouchbaseMock.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public CouchbaseMock(String hostname, int port, int numNodes, int bucketStartPort, int numVBuckets) throws IOException {
        this(hostname, port, numNodes, bucketStartPort, numVBuckets, null);
    }

    public CouchbaseMock(String hostname, int port, int numNodes, int numVBuckets) throws IOException {
        this(hostname, port, numNodes, 0, numVBuckets, null);
    }

    public CouchbaseMock(String hostname, int port, int numNodes, int numVBuckets, String bucketSpec) throws IOException {
        this(hostname, port, numNodes, 0, numVBuckets, bucketSpec);
    }

    public void waitForStartup() throws InterruptedException {
        this.startupLatch.await();
    }

    public int getHttpPort() {
        return this.port;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public static void main(String[] args) {
        int port = 8091;
        int nodes = 100;
        int vbuckets = 4096;
        String harakirimonitor = null;
        String hostname = null;
        String bucketsSpec = null;
        Getopt getopt = new Getopt();
        getopt.addOption(new Getopt.CommandLineOption('h', "--host", true)).addOption(new Getopt.CommandLineOption('b', "--buckets", true)).addOption(new Getopt.CommandLineOption('p', "--port", true)).addOption(new Getopt.CommandLineOption('n', "--nodes", true)).addOption(new Getopt.CommandLineOption('v', "--vbuckets", true)).addOption(new Getopt.CommandLineOption('\u0000', "--harakiri-monitor", true)).addOption(new Getopt.CommandLineOption('?', "--help", false));
        List<Getopt.Entry> options = getopt.parse(args);
        for (Getopt.Entry e : options) {
            if (e.key.equals("-h") || e.key.equals("--host")) {
                hostname = e.value;
                continue;
            }
            if (e.key.equals("-b") || e.key.equals("--buckets")) {
                bucketsSpec = e.value;
                continue;
            }
            if (e.key.equals("-p") || e.key.equals("--port")) {
                port = Integer.parseInt(e.value);
                continue;
            }
            if (e.key.equals("-n") || e.key.equals("--nodes")) {
                nodes = Integer.parseInt(e.value);
                continue;
            }
            if (e.key.equals("-v") || e.key.equals("--vbuckets")) {
                vbuckets = Integer.parseInt(e.value);
                continue;
            }
            if (e.key.equals("--harakiri-monitor")) {
                int idx = e.value.indexOf(58);
                if (idx == -1) {
                    System.err.println("ERROR: --harakiri-monitor requires host:port");
                }
                harakirimonitor = e.value;
                continue;
            }
            if (!e.key.equals("-?") && !e.key.equals("--help")) continue;
            System.out.println("Usage: --host=hostname --buckets=bucketsSpec --port=REST-port --nodes=#nodes --vbuckets=#vbuckets --harakiri-monitor=host:port");
            System.out.println("  Default values: REST-port:    8091");
            System.out.println("                  bucketsSpec:  default:");
            System.out.println("                  #nodes:       100");
            System.out.println("                  #vbuckets:    4096");
            System.out.println("Buckets descriptions is a comma-separated list of {name}:{password}:{bucket type} pairs. To allow unauthorized connections, omit password. Third parameter could be either 'memcache' or 'couchbase' (default value is 'couchbase'). E.g.\n    default:,test:,protected:secret,cache::memcache");
            System.exit(0);
        }
        try {
            if (port == 0) {
                ServerSocket server = new ServerSocket(0);
                port = server.getLocalPort();
                server.close();
            }
            CouchbaseMock mock = new CouchbaseMock(hostname, port, nodes, vbuckets, bucketsSpec);
            if (harakirimonitor != null) {
                mock.setupHarakiriMonitor(harakirimonitor, true);
            }
            mock.start();
        }
        catch (Exception e) {
            Logger.getLogger(CouchbaseMock.class.getName()).log(Level.SEVERE, "Fatal error! failed to create socket: ", e);
        }
    }

    public void failSome(String name, float percentage) {
        Bucket bucket = this.getBuckets().get(name);
        if (bucket != null) {
            bucket.failSome(percentage);
        }
    }

    public void fixSome(String name, float percentage) {
        Bucket bucket = this.getBuckets().get(name);
        if (bucket != null) {
            bucket.fixSome(percentage);
        }
    }

    public void stop() {
        if (this.httpServer != null) {
            this.httpServer.stop(0);
            this.httpServer = null;
        }
        for (Thread t : this.nodeThreads) {
            t.interrupt();
            do {
                try {
                    t.join();
                    t = null;
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(CouchbaseMock.class.getName()).log(Level.SEVERE, null, ex);
                    t.interrupt();
                }
            } while (t != null);
        }
    }

    public void start() {
        this.nodeThreads = new ArrayList();
        for (String s : this.getBuckets().keySet()) {
            Bucket bucket = this.getBuckets().get(s);
            bucket.start(this.nodeThreads);
        }
        try {
            this.httpServer = HttpServer.create(new InetSocketAddress(this.port), 10);
            this.httpServer.createContext("/pools", new PoolsHandler(this)).setAuthenticator(this.authenticator);
            this.httpServer.setExecutor(Executors.newCachedThreadPool());
            this.httpServer.start();
            this.startupLatch.countDown();
        }
        catch (IOException ex) {
            Logger.getLogger(CouchbaseMock.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static class HarakiriMonitor
    extends Observable
    implements Runnable {
        private final boolean terminate;
        private final CouchbaseMock mock;
        private BufferedReader input;
        private OutputStream output;
        private Socket sock;
        private Thread thread;

        public HarakiriMonitor(String host, int port, boolean terminate, CouchbaseMock mock) throws IOException {
            this.mock = mock;
            this.terminate = terminate;
            this.sock = new Socket(host, port);
            this.input = new BufferedReader(new InputStreamReader(this.sock.getInputStream()));
            this.output = this.sock.getOutputStream();
        }

        public void start() {
            this.thread = new Thread((Runnable)this, "HarakiriMonitor");
            this.thread.start();
        }

        public void stop() {
            this.thread.interrupt();
        }

        @Override
        public void run() {
            boolean closed = false;
            String http = "" + this.mock.getHttpPort() + '\u0000';
            try {
                this.mock.waitForStartup();
                this.output.write(http.getBytes());
                this.output.flush();
            }
            catch (InterruptedException ex) {
                closed = true;
            }
            catch (IOException ex) {
                closed = true;
            }
            while (!closed) {
                try {
                    String[] tokens;
                    String packet = this.input.readLine();
                    if (packet == null) {
                        closed = true;
                        continue;
                    }
                    if (this.mock == null || (tokens = packet.split(",")).length < 2) continue;
                    try {
                        String command = tokens[0];
                        int idx = Integer.parseInt(tokens[1].trim());
                        String bucket = tokens.length == 3 ? tokens[2] : "default";
                        if ("failover".equals(command)) {
                            this.mock.failover(bucket, idx);
                            this.setChanged();
                            this.notifyObservers();
                            continue;
                        }
                        if (!"respawn".equals(command)) continue;
                        this.mock.respawn(bucket, idx);
                        this.setChanged();
                        this.notifyObservers();
                    }
                    catch (NumberFormatException ex) {
                    }
                }
                catch (IOException e) {
                    closed = true;
                }
            }
            if (this.terminate) {
                System.exit(1);
            }
        }
    }
}

