# This Makefile.PL for Module-Runtime-Conflicts was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.38.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.006;
use ExtUtils::MakeMaker;

eval {
  require Module::Metadata;
  if (my $mr = Module::Metadata->new_from_module('Module::Runtime')) {
    my $mr_version = $mr->version;
    if ($mr_version and $mr_version >= '0.014') {
      foreach my $upstream ([ 'Moose' => '2.1202' ], [ 'MooseX::NonMoose' => '0.24' ], [ 'Elasticsearch' => '1.00' ]) {
        if (my $mmd = Module::Metadata->new_from_module($upstream->[0])) {
          my $upstream_version = $mmd->version;
          if ($upstream_version and $upstream_version <= $upstream->[1]) {
            print STDERR "\n", ('*' x 72), "\n\n";
            print STDERR "WARNING! Detected incompatible version of $upstream->[0]! Please upgrade!\n";
            print STDERR "\n", ('*' x 72), "\n\n";
          }
        }
      }
    }
  }
};

my %WriteMakefileArgs = (
  "ABSTRACT" => "Provide information on conflicts for Module::Runtime",
  "AUTHOR" => "Karen Etheridge <ether\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "Module-Runtime-Conflicts",
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.006",
  "NAME" => "Module::Runtime::Conflicts",
  "PREREQ_PM" => {
    "Dist::CheckConflicts" => 0,
    "Module::Runtime" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "File::Spec" => 0,
    "Module::Metadata" => 0,
    "Test::More" => "0.88",
    "if" => 0
  },
  "VERSION" => "0.003",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Dist::CheckConflicts" => 0,
  "File::Spec" => 0,
  "Module::Metadata" => 0,
  "Module::Runtime" => 0,
  "Test::More" => "0.88",
  "if" => 0,
  "strict" => 0,
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
