package Datatypes::v1_0::Element;
use strict;
use warnings;
use version;our $VERSION = qw("v1.0");
use base 'Exporter';

=head1 NAME

Datatypes::v1_0::Element -  static class for basic element manipulations

=head1 DESCRIPTION

it exports only single call - getElement which allows to create XML DOM out of perl object
This module was automatically build by L<XML::RelaxNG::Compact::PXB>.

=cut

our @EXPORT_OK   = qw(&getElement);

use Readonly;
use Scalar::Util qw(blessed);
use XML::LibXML;
use Log::Log4perl qw(get_logger);
 
use Data::Dumper;
Readonly::Scalar our $CLASSPATH =>  'Datatypes::v1_0::Element';
Readonly::Hash   our %NSREGISTRY => ( 'xsd' => 'http://www.w3.org/2001/XMLSchema',
 'xsi' => 'http://www.w3.org/2001/XMLSchema-instance',
 'nsid' => 'http://URI/nsid',
 'nsid2' => 'http://URI/nsid2',
);

our $LOGGER = get_logger($CLASSPATH);

=head1 METHODS


=head2    getElement ()

 create   element from some data struct and return it as DOM
 accepts 1 parameter - hashref to hash of keyd parameters

 where:
 
  'name' =>  name of the element
 
  'ns' => [ namespace id1, namespace id2 ...] array ref
 
  'parent' => parent DOM if provided ( element will be created in context of the parent),
 
  'attributes' =>  arrayref to the array of attributes pairs,
                   where to get i-th attribute one has to  $attr->[i]->[0] for  name  and  $attr->[i]->[1]  for value
 
  'text' => <CDATA>

 creates  new   element, returns this element

=back

=cut

sub  getElement {
    my $param = shift;
    my $data;
    unless($param && ref($param) eq 'HASH' &&  $param->{name}) {
       $LOGGER->logdie(" Need single hashref parameter as { name => '',  parent => DOM_obj, attributes => [], text => ''} with at least name key defined");
    }
    my $name =   $param->{name};
    my $attrs =  $param->{attributes};
    my $text =   $param->{text};
    my $nss =    $param->{ns}; ## reference to array ref with ns prefixes for this element
   
    if($param->{parent} && blessed($param->{parent}) && $param->{parent}->isa('XML::LibXML::Document')) {
            $data =  $param->{parent}->createElement($name);
    } else {
            $data =  XML::LibXML::Element->new($name);
    }
    ## validation of the namespace prefixes  registered
    if($nss)  {
            foreach my $ns (@{$nss}) {
                next unless $ns;
                unless($NSREGISTRY{$ns}) {
		    $LOGGER->error("Attempted to create element with un-supported namespace prefix"); 
		}
                $data->setNamespace($NSREGISTRY{$ns}, $ns, 1);
            }
    } else {
            $LOGGER->error("Attempted to create element without namespace");
    }
    if (($attrs && ref($attrs) eq 'ARRAY') || $text) {
            if($attrs && ref($attrs) eq 'ARRAY') {
                foreach my $attr (@{$attrs}) {
                    if($attr->[0] && $attr->[1]) {
                        unless(ref($attr->[1]))   {
                            $data->setAttribute($attr->[0], $attr->[1]);
                        } else {
                            $LOGGER->warn("Attempted to create ".$attr->[0]." with this: ".$attr->[1]." dump:" . Dumper  $attr->[1]);
                        }
                    }
                }
            }
            if($text)  {
                unless(ref($text)) {
                    my $text_el = XML::LibXML::Text->new($text);
                    $data->appendChild($text_el);
                }  else {
                    $LOGGER->warn(" Attempted to create text with non scalar: $text dump:" . Dumper $text);
                }
            }
    } else {
        $LOGGER->warn(" Attempted to create empty element with name $name, failed to do so, will return undef ");
    }
    return $data;
}



1;

__END__


=head1  SEE ALSO

Automatically generated by L<XML::RelaxNG::Compact::PXB> 

=head1 AUTHOR

Joe Doe

=head1 COPYRIGHT

Copyright (c) 2008, Joe Doe. All rights reserved.

=head1 LICENSE

This program is free software.
You can redistribute it and/or modify it under the same terms as Perl itself.

=cut


