


* * *

<!-- DO NOT EDIT: File generated by docs/Generate.sh -->

NAME
====

Net::Packet - Decoding network frames/packets.

SYNOPSIS
========

    # use Net::Packet::Ethernet :short;
    # use Net::Packet::IPv4 :short;
    # use Net::Packet::UDP :short;

    my $pkt = Buf.new([...]);

    my $eth = Ethernet.decode($pkt);
    printf "%s -> %s: ", $eth.src.Str, $eth.dst.Str;

    my $ip  = IPv4.decode($eth.data, $eth);
    printf "%s -> %s: ", $ip.src.Str, $ip.src.Str;

    my $udp = UDP.decode($ip.data, $ip);
    printf "%d -> %d\n", $udp.src_port, $udp.dst_port;

Prints '11:22:33:AA:BB:CC -> 44:55:66:EE:DD:FF: 11.22.33.44 -> 55.66.77.88: 443 -> 49875'. Following code prints the same:

    # use Net::Ethernet :short;

    my $pkt = Buf.new([...]);

    my $eth = Ethernet.decode($pkt);
    printf "%s -> %s: ", $eth.src.Str, $eth.dst.Str;

    if $eth.pl ~~ IPv4 { # .pl (for PayLoad) decodes the payload
       printf "%s -> %s: ", $eth.pl.src.Str, $eth.pl.dst.Str;

       if $eth.pl.pl ~~ UDP {
          printf "%d -> %d\n", $eth.pl.pl.src_port, $eth.pl.pl.dst_port;
       }
    }

EXPORTS
=======

    use Net::Packet :util;

exports:

    sub unpack_n(); # See description
    sub unpack_N(); # See description

DESCRIPTION
===========



module Net::Packet
------------------

### Subroutines

    unpack_n($buf, Int $i) returns Int
      Decodes a 16-bit integer from $buf, starting at $buf[$i].

    unpack_N($buf, Int $i) returns Int
      Decodes a 32-bit integer from $buf, starting at $buf[$i].


* * *

<!-- DO NOT EDIT: File generated by docs/Generate.sh -->

NAME
====

Net::Packet::Ethernet

SYNOPSIS
========

    use Net::Packet::Ethernet :short;

    my $frame = Buf.new([...]);
    my $eth = Ethernet.decode($frame);

    say sprintf '%s -> %s: %s',
        $eth.src.Str, $eth.src.Str, $eth.type;

Prints: 66:77:88:99:AA:BB -> 66:77:88:99:AA:BB: IPv4

EXPORTS
=======

    Net::Packet::Ethernet

:short trait adds exports:

    constant Ethernet  ::= Net::Packet::Ethernet;
    constant MAC_addr  ::= Net::Packet::MAC_addr;
    constnat EtherType ::= Net::Packet::EtherType;

DESCRIPTION
===========

Net::Packet::Ethernet takes a byte buffer and returns a corresponding packet object. The byte buffer can be of the builtin Buf type or the C_Buf type of Net::Pcap.

class Net::Packet::Ethernet
---------------------------

    is Net::Packet::Base;

### Attributes

     $.src         is rw is Net::Packet::Ethernet::MAC_addr
    $.dst         is rw is Net::Packet::Ethernet::MAC_addr
      Source/destination MAC address

    $.type        is rw is Net::Packet::Ethernet::EtherType
      Payload type.

    $.is_802_1Q   is rw is Bool
      Set if packet is of type IEE802.1Q.
      
    $.pcp         is rw is Int
    $.dei         is rw is Int
    $.vid         is rw is Int
      PCP/DEI/VID field. Only used if $.is_802_1Q is set.

    $.is_802_1ad  is rw is Bool
      Set if packet is of type IEEE802.1ad.

    $.s-vid       is rw is Int
    $.s-dei       is rw is Int
    $.s-pcp       is rw is Int
      PCP/DEI/VID field of the service provider. Only used if IEEE802.1ad is set.

### Methods

    .decode($frame, Net::Packet::Base $parent?) returns Net::Packet::Ethernet
      Returns the Ethernet packet corresponding to $frame.

    .encode()
      Writes the packet to $.frame buffer, including the payload.

    .pl() returns Proxy is rw
      Returns a Proxy for the payload of this packet.
      Usage:
        $eth.pl = ...
        my $ip = $eth.pl.


* * *

<!-- DO NOT EDIT: File generated by docs/Generate.sh -->

NAME
====

Net::Packet::MAC_addr - Decode and format MAC addresses.

SYNOPSIS
========

    use Net::Packet::MAC_addr :short;

    my $buf = Buf.new([0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77]);
    my $mac = MAC_addr.unpack($buf, 1); # Start unpacking at $buf[1].
    say $mac.Str; # '11:22:33:44:55:66'

    my $mac = MAC_addr.new(0x112233AABBCC);
    say $mac.Str; # '11:22:33:AA:BB:CC'

EXPORTS
=======

    Net::Packet::MAC_addr

:short trait adds export:

    constant MAC_addr ::= Net::Packet::MAC_addr

DESCRIPTION
===========



class Net::Packet::MAC_addr
---------------------------

### Attributes

     $.addr  is rw is Int
       Address

### Methods

    .new(Int $addr) returns MAC_addr
    .new(Str $addr) returns MAC_addr
      Constructor, takes $addr:
       - Int;
       - Str in the form of '00:11:22:AA:BB:CC'.

    .unpack($buf, Int $i) returns MAC_addr
      Constructor, unpacks address from buffer $buf starting at position $i.
      $buf can be of builtin type Buf or C_Buf from Net::Pcap.

    .octets() returns Array
      Returns the address represented by an Array of 6 Ints (one for each byte of
      the address).

    .Int() returns Int
      Returns the address as Int.

    .Str() returns Str
      Returns the address as string in the form of '00:11:22:AA:BB:CC'.

    .Buf() returns Buf
      Returns the address as a byte string.


* * *

<!-- DO NOT EDIT: File generated by docs/Generate.sh -->

NAME
====

Net::Packet::EtherType - Enumerator to describe EtherType.

SYNOPSIS
========

    use Net::Packet::EtherType :short;

    my $etype_Int = 0x0800; # EtherType value of IPv4
    my $etype = EtherType($etype_Int);
    say $etype; # 'IPv4'

    $etype = EtherType::IPv4;
    say $etype.value.base(16); # '800'

    say EtherType.enums; # Prints all implemented values.

DESCRIPTION
===========



enum Net::Packet::EtherType
---------------------------


* * *

<!-- DO NOT EDIT: File generated by docs/Generate.sh -->

NAME
====

Net::Packet::IPv4

SYNOPSIS
========

    use Net::Packet::IPv4 :short;

    my $frame = Buf.new([...]);
    my $ip = IPv4.new($frame);

    say sprintf '%s -> %s: %s',
        $ip.src.Str, $ip.dst.Str, $ip.proto;

EXPORTS
=======

    Net::Packet::IPv4

:short trait adds exports:

    constant IPv4       ::= Net::Packet::IPv4;
    constant IPv4_addr  ::= Net::Packet::IPv4_addr;
    constant IP_proto   ::= Net::Packet::IP_proto;

DESCRIPTION
===========

Net::Packet::IPv4 takes a byte buffer and returns a corresponding packet object. The byte buffer can be of the builtin Buf type or the C_Buf type of Net::Pcap.

class Net::Packet::IPv4
-----------------------

    is Net::Packet::Base

### Attributes

     $.src              is rw is Net::Packet::IPv4_addr
    $.dst              is rw is Net::Packet::IPv4_addr
      Source/destination ip address field.

    $.proto            is rw is Net::Packet::IP_proto
      Protocol field. 

    $.id               is rw is Int
    $.fragment_offset  is rw is Int
    $.flags            is rw is Int
      Identification/Fragment offset/Flags field. All these things
      control fragmentation of IP packets.

    $.ihl              is rw is Int
      Internet Header Length field. Used to specify length of the header.
      IPv4 has extra field for options (option fields are NOT YET
      IMPLEMENTED)
      
    $.dscp             is rw is Int
    $.ecn              is rw is Int
      DSCP/ECN field.  

    $.total_length     is rw is Int
      Total length of packet (fragment) size including header and payload in
      bytes.

    $.ttl              is rw is Int
      Time To Live field. Helps prevent datagrams from going in circles. It
      limits the datagrams lifetime.

    $.hdr_chksum       is rw is Int
      Header checksum field.

### Methods

    .decode($frame, Net::Packet::Base $parent?) returns Net::Packet::IPv4
      Returns the IPv4 packet corresponding to $frame.

    .pl() returns Proxy is rw
      Returns a Proxy for the payload of this packet.
      Usage:
        $eth.pl = ...
        my $ip = $eth.pl.


* * *

<!-- DO NOT EDIT: File generated by docs/Generate.sh -->

NAME
====

Net::Packet::IPv4_addr

SYNOPSIS
========

    use IPv4_addr :short;

    my $buf = Buf.new([0, 11, 22, 33, 44, 55]);
    my $ip  = IPv4_addr.unpack($buf, 1); # Starts unpacking at $buf[1].

    say $ip.Str; '11.22.33.44'

EXPORTS
=======

    Net::Packet::IPv4_addr;

:short traits adds export:

    constant IPv4_addr ::= Net::Packet::IPv4_addr;

DESCRIPTION
===========



class Net::Packet::IPv4_addr
----------------------------

### Attributes

     $.addr  is rw is Int
       Address

### Methods

    .new(Int $addr) returns IPv4_addr
    .new(Str $addr) returns IPv4_addr
      Constructor, takes $addr as:
       - Int;
       - Str in the form of '1.222.33.44'.

    .unpack($buf, Int $i) returns IPv4_addr
      Constructor, unpacks address from buffer $buf starting at position $i.
      $buf can be of builtin type Buf or C_Buf from Net::Pcap.

    .octets() returns Array
      Returns the address represented by an Array of 4 Ints (one for each byte of
      the address).

    .Int() returns Int
      Returns the address as Int.

    .Str() returns Str
      Returns the address as string in the form of '11.22.33.44'.

    .Buf() returns Buf
      Returns the address as a byte string.


* * *

<!-- DO NOT EDIT: File generated by docs/Generate.sh -->

NAME
====

Net::Packet::IP_proto

SYNOPSIS
========

    use Net::Packet::IP_proto :short;

    my $ipproto_Int = 0x06;
    my $ipproto = IP_proto($ipproto_Int);
    say $ipproto; # 'TCP'

    $ipproto = IP_proto::UDP;
    say $ipproto.value.base(16); # '11'

    say IP_proto.enums; # Lists all implemented values.

EXPORTS
=======

    Net::Packet::IP_proto

:short trait adds export:

    constant IP_proto ::= Net::Packet::IP_proto;

DESCRIPTION
===========



enum Net::Packet::IP_proto
--------------------------


* * *

<!-- DO NOT EDIT: File generated by docs/Generate.sh -->

NAME
====

Net::Packet::UDP

SYNOPSIS
========

    use Net::Packet::UDP :short;

    my $buf = Buf.new([...]);
    my $udp = UDP.decode($buf);

    say sprintf '%d -> %d: %d\n',
        $udp.src_port, $udp.dst_port, $udp.length;

Prints '53 -> 49875: 90'

EXPORTS
=======

    Net::Packet::UDP

:short trait adds exports:

    constant UDP ::= Net::Packet::UDP;

DESCRIPTION
===========

Net::Packet::UDP takes a byte buffer and returns a corresponding packet object. The byte buffer can be of the builtin Buf type or the C_Buf type of Net::Pcap.

class Net::Packet::UDP
----------------------

    is Net::Packet::Base

### Attributes

    $.src_port  is rw is Int
    $.dst_port  is rw is Int
      Source/Destination port fields.

    $.length    is rw is Int
      Packet length in bytes including header and data.

    $.chksum    is rw is Int
      Checksum field for erro checking of the header and data.

    $.data      is rw is Buf/C_Buf
      UDP data following the UDP header. Type is the same as the $frame given to .decode().

### Methods

    .decode($frame, Net::Packet::Base $parent?) returns Net::Packet::UDP
      Returns the UDP packet corresponding to $frame.


* * *

<!-- DO NOT EDIT: File generated by docs/Generate.sh -->

NAME
====

Net::Packet::ARP - Interface for decoding ARP packets.

SYNOPSIS
========

    use Net::Packet::ARP :short;

    my $frame = Buf.new([...]);
    my $arp = ARP.decode($frame);

    say sprintf '%s(%s) -> %s(%s): %s',
        $arp.src_hw_addr.Str, $arp.src_proto_addr.Str,
        $arp.dst_hw_addr.Str, $arp.dst_proto_addr.Str,
        $arp.operation;

Prints '66:77:88:99:AA:BB(102.119.136.153) -> 00:11:22:33:44:55(0.17.34.51): Request'

EXPORTS
=======

    Net::Packet::ARP
    Net::Packet::ARP::HardwareType
    Net::Packet::ARP::Operation

:short trait adds exports:

    constant ARP               ::= Net::Packet::ARP
    # Implies:
             ARP::HardwareType ::= Net::Packet::ARP::HardwareType
             ARP::Operation    ::= Net::Packet::ARP::Operation

DESCRIPTION
===========

Net::Packet::ARP takes a byte buffer and returns a corresponding packet object. The byte buffer can be of the builtin Buf type or the C_Buf type of Net::Pcap.

enum Net::Packet::ARP::HardwareType
-----------------------------------

    Type to describe the hardware type field of an ARP packet.

enum Net::Packet::ARP::Operation
--------------------------------

    Type to describe the operation field of an ARP packet.

class Net::Packet::ARP
----------------------

    is Net::Packet::Base

### Attributes

     $.hw_type         is rw is Net::Packet::ARP::HardwareType
      Hardware address type field

    $.proto_type      is rw is Net::Packet::EtherType
      Protocol address type field

    $.hw_len          is rw is Int
      Hardware address length field

    $.proto_len       is rw is Int
      Protocol address length field

    $.operation       is rw is Net::Packet::ARP::Operation
      Operation field
       
    $.src_hw_addr     is rw
    $.dst_hw_addr     is rw
    $.src_proto_addr  is rw
    $.dst_proto_addr  is rw
      Sender/Receiver hardware/protocol address fields. Typed with the type
      of address (eg. Net::Packet::IPv4, Net::Packet::MAC_addr).

### Methods

    .decode($frame, Net::Packet::Base $parent?) returns Net::Packet::ARP
      Returns the ARP packet corresponding to $frame.

    .encode()
      Writes to packet to the $.frame buffer.


* * *

<!-- DO NOT EDIT: File generated by docs/Generate.sh -->

NAME
====

Net::Packet::ICMP

SYNOPSIS
========

    use Net::Packet::ICMP :short;

    my $frame = Buf.new([...]);
    my $icmp = ICMP.decode($frame);

    # New ping request:
    my $icmp = ICMP.new(:type(8), :code(0));
    $icmp.id = 0xCAFE;
    $icmp.sequence_number = 0xBEEF;

EXPORTS
=======

    class Net::Packet::ICMP

:short trait adds export:

    constant ICMP ::= Net::Packet::ICMP

DESCRIPTION
===========



class Net::Packet::ICMP
-----------------------

    is Net::Packet::Base

### Attributes

    $.type    is rw is Int
    $.code    is rw is Int
    $.chksum  is rw is Int
      ICMP type/code/checksum field.

    $.hdr     is rw
      Rest-of-header, four bytes fields. Contents vary based on ICMP type and code.
      can either be of builtin type Buf, or C_Buf (from Net::Pcap).

### Methods

    .decode($frame, Net::Packet::Base $parent?) returns Net::Packet::ICMP
      Returns the ICMP packet corresponding to $frame.

    .id() returns Proxy is rw
      Returns a Proxy for the identifier of this packet. Only valid for specific
      combinations of $.type and $.code, as per ICMP specification, else it dies.
      Usage:
        $icmp.id = ...
        my $id = $eth.id.

    .sequence_number() returns Proxy is rw
      Returns a Proxy for the sequence number of this packet. Only valid for specific
      combinations of $.type and $.code, as per ICMP specification, else it dies.
      Usage:
        $icmp.sequence_number = ...
        my $id = $eth.sequence_number.
